CREATE TABLE CRM_Turnos_Tipos (
	Id_Turno_Tipo SMALLINT NOT NULL IDENTITY(1,1),
	Id_Usuario SMALLINT,
	Descripcion VARCHAR(255),
	Frecuencia INT,						--minutos - cada cuanto
	Dias_Futuro SMALLINT,				--dias - hasta cuando se puede sacar
	Minutos_Anticipacion INT,			--minutos - tiempo antes
	Emails VARCHAR(3000) ,
	Semana CHAR(7),						--0111110 1 cada dioa primero domingo
	Hora_Inicio DATETIME,
	Hora_Fin DATETIME,
	Turnos_Dia INT,
    Activo	TINYINT,
	CONSTRAINT PK_CTT_PorId PRIMARY KEY CLUSTERED (Id_Turno_Tipo)
)
GO

CREATE UNIQUE INDEX IX_CTT_PorDescrip ON CRM_Turnos_Tipos (Descripcion)
GO



CREATE TABLE CRM_Turnos (
	Id_Turno BIGINT NOT NULL IDENTITY(1,1),
	Id_Usuario SMALLINT,
	Id_Cliente INT,
	Id_Turno_Tipo SMALLINT,
	Fecha DATETIME,
	Descripcion VARCHAR(255),
	Flag_Bloqueado TINYINT,
	Activo TINYINT,
	CONSTRAINT PK_CTur_PorId PRIMARY KEY CLUSTERED (Id_Turno)
)
GO

CREATE INDEX IX_CTur_PorCli ON CRM_Turnos (Id_Cliente,Fecha)
GO

CREATE INDEX IX_CTur_PorUsu ON CRM_Turnos (Id_Usuario,Fecha)
GO

CREATE INDEX IX_CTur_PorTurTipo ON CRM_Turnos (Id_Turno_Tipo,Fecha)
GO

ALTER TABLE CRM_Turnos ADD CONSTRAINT FK_CTur_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
GO

ALTER TABLE CRM_Turnos ADD CONSTRAINT FK_CTur_Seg_User FOREIGN KEY (Id_Usuario) REFERENCES Seg_User ([No])
GO

ALTER TABLE CRM_Turnos ADD CONSTRAINT FK_CTur_Turnos_Tipos FOREIGN KEY (Id_Turno_Tipo) REFERENCES CRM_Turnos_Tipos (Id_Turno_Tipo)
GO
